# Rome-Lib

Note: Not layered, but often used in layered cases. Different versions have had various numbers of graphs. We include the largest of these datasets. Also sometimes referred to in the literature as “Pert DAG”.
Origin Notes: Collected by Di Battista et al. and presented in their paper ”An experimental comparison of four graph drawing algorithms”. Mostly “real” networks such as software companies, government, software engineering books, database design, and journal articles on visualization.
Originally sent as an extended abstract to Computational Geometry in 1995 — the same description was published as https://doi.org/10.1016/S0925-7721(96)00005-3 2 years later.

http://graphdrawing.org describes it as: “Test suites of directed and undirected graphs from the http://www.dia.uniroma3.it/~gdt/ homepage (also known as the Rome Graphs).”
graph features handled: Generic
Graph features in papers: generic,directed edges,layered graphs,n-layers,clusters (pre-existing),compound graphs,layered graphs,n-layers,circular,planar,sparse,trees,ortho,ortho-radial
Origin Paper: An experimental comparison of four graph drawing algorithms (https://www.notion.so/An-experimental-comparison-of-four-graph-drawing-algorithms-4ef2a9eb95d6462fa997a16dc6ed2c2f?pvs=21), An experimental comparison of three graph drawing algorithms (extended abstract) (https://www.notion.so/An-experimental-comparison-of-three-graph-drawing-algorithms-extended-abstract-85bcd0ec675440fab9ba0c4f187b9e02?pvs=21)
Originally found at: http://www.graphdrawing.org/data.html
Size: 11534 graphs, 10 to 100 nodes, 9 to 158 edges 
Number of Graphs: 11534
format: GraphML
Child collections: Pert DAG (Pert%20DAG%2096b0f23e2c66409c928697e247c77d7c.md)
Appeared in years: 2008,2006,2022,2018,2021,2003,1997,2016,2017,2020,2019,2011
Type of Collection: Uniform Benchmark
is it stored properly?: No
must be analyzed: Yes
In repo?: Yes
Related to Literature - Algorithm (1) (Dataset tag relations): Experiments on Exact Crossing Minimization Using Column Generation (https://www.notion.so/Experiments-on-Exact-Crossing-Minimization-Using-Column-Generation-1cd4f50b26dd44caa895d17fab86667a?pvs=21), A New Approach to Exact Crossing
Minimization (https://www.notion.so/A-New-Approach-to-Exact-Crossing-Minimization-2bfd0ee19a944002b50f519492a0c33d?pvs=21), Deep Neural Network for DrawiNg
Networks, (DN N )2 (https://www.notion.so/Deep-Neural-Network-for-DrawiNg-Networks-DN-N-2-2c90c9d3d07e4b489840f77c364c60d3?pvs=21), A Greedy Heuristic for Crossing-Angle Maximization (https://www.notion.so/A-Greedy-Heuristic-for-Crossing-Angle-Maximization-3570c65b497c41e999463e9addefca2e?pvs=21), An Experimental Study of Crossing
Minimization Heuristics (https://www.notion.so/An-Experimental-Study-of-Crossing-Minimization-Heuristics-421c870d311943faa795f2115d2ca17e?pvs=21), Layer-Free Upward Crossing Minimization (https://www.notion.so/Layer-Free-Upward-Crossing-Minimization-74e10beabfcd4c5c86314a0ccd287610?pvs=21), Stratisfimal Layout: A modular optimization model for laying out layered node-link network visualizations (https://www.notion.so/Stratisfimal-Layout-A-modular-optimization-model-for-laying-out-layered-node-link-network-visualiza-77fd27b418d64ef6ab570cffd0ec4a24?pvs=21), An effective crossing minimisation heuristic based on star insertion (https://www.notion.so/An-effective-crossing-minimisation-heuristic-based-on-star-insertion-888933e03a604489ada5360688abe597?pvs=21), Improved circular layouts (https://www.notion.so/Improved-circular-layouts-8e3c81eb7f5e488b9a9dde434ad155cb?pvs=21), An Interactive Tool to Explore and Improve the Ply Number of Drawings (https://www.notion.so/An-Interactive-Tool-to-Explore-and-Improve-the-Ply-Number-of-Drawings-9141cfad08234c60a979ca207ada6a86?pvs=21), ? Aesthetic Discrimination of Graph Layouts (https://www.notion.so/Aesthetic-Discrimination-of-Graph-Layouts-98cc70abc7424e7895cf73e988563219?pvs=21), A branch-and-cut approach to the crossing number problem (https://www.notion.so/A-branch-and-cut-approach-to-the-crossing-number-problem-9f6d0fc8bd22490eaa0419efd296f2fe?pvs=21), An ILP-based Proof System for the Crossing
Number Problem (https://www.notion.so/An-ILP-based-Proof-System-for-the-Crossing-Number-Problem-b61271c4f96a4633aba0179af767a5e0?pvs=21), An experimental comparison of four graph drawing algorithms (https://www.notion.so/An-experimental-comparison-of-four-graph-drawing-algorithms-b66a426dec90451ea5335ae1a7a25290?pvs=21), A Heuristic Approach Towards Drawings of Graphs with High Crossing Resolution (https://www.notion.so/A-Heuristic-Approach-Towards-Drawings-of-Graphs-with-High-Crossing-Resolution-bfbf57711103440a818c190d42fdb3c1?pvs=21), Advances in the Planarization Method: Effective Multiple Edge Insertions (https://www.notion.so/Advances-in-the-Planarization-Method-Effective-Multiple-Edge-Insertions-c518ce875daa4fe7b003ad506eb9a347?pvs=21), Experimental Analysis of the Accessibility of Drawings with Few Segments (https://www.notion.so/Experimental-Analysis-of-the-Accessibility-of-Drawings-with-Few-Segments-c6a50c32ec8a4fde9501b61f89625df8?pvs=21), A Note on the Practicality of Maximal Planar Subgraph Algorithms (https://www.notion.so/A-Note-on-the-Practicality-of-Maximal-Planar-Subgraph-Algorithms-cbca5aa1135a4ba29ea6e508f1c4d02b?pvs=21), Star-Struck by Fixed Embeddings:
Modern Crossing Number Heuristics (https://www.notion.so/Star-Struck-by-Fixed-Embeddings-Modern-Crossing-Number-Heuristics-d8f0e972b962439d8b368e8a28a7046a?pvs=21), An Integer-Linear Program
for Bend-Minimization in Ortho-Radial
Drawings (https://www.notion.so/An-Integer-Linear-Program-for-Bend-Minimization-in-Ortho-Radial-Drawings-dd7c606905064bd9931cf69e0c5fc828?pvs=21)
cleaned format?: Yes
duplicate?: No
link works?: Yes
Added in paper: Yes
OSF link json: https://files.osf.io/v1/resources/j7ucv/providers/osfstorage/64d90ec4803e0c0b00558bc1
Origin paper plaintext: An experimental comparison of four graph drawing algorithms, An experimental comparison of three graph drawing algorithms (extended abstract)
Page id: c2f20984de724f4c89764b0bc494e99e
unavailable/skip: No
Cleaned ALL data: No
OSF link gexf: https://files.osf.io/v1/resources/j7ucv/providers/osfstorage/64d947f91101aa0dc66a0c4d
OSF link gml: https://files.osf.io/v1/resources/j7ucv/providers/osfstorage/64d96db0803e0c0cb7558c0f
OSF link graphml: https://files.osf.io/v1/resources/j7ucv/providers/osfstorage/64d971aa4cf748115a055897
first look: No
sparkline data: {'min': 10, 'max': 110, 'step_size': 5, 'num_bins': 23, 'bins': [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 105, 110], 'num_nodes': [0, 0, 681, 726, 427, 412, 630, 1404, 1162, 638, 451, 594, 688, 484, 455, 553, 445, 343, 582, 713, 142, 3, 1]}
Related to Literature - Algorithm (Dataset tag relations) 1: A branch-and-cut approach to the crossing number problem (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/A%20branch-and-cut%20approach%20to%20the%20crossing%20number%20p%20624ac4312cf941d2be7d815abe24b5b1.md), Layer-Free Upward Crossing Minimization (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Layer-Free%20Upward%20Crossing%20Minimization%20676f8a507ff343b5ae83c34446796fb5.md), Experiments on Exact Crossing Minimization Using Column Generation (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Experiments%20on%20Exact%20Crossing%20Minimization%20Using%20C%208eba57a3647f4f22960d2d0f794c3cbf.md), Stratisfimal Layout: A modular optimization model for laying out layered node-link network visualizations (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Stratisfimal%20Layout%20A%20modular%20optimization%20model%20f%20ad2a312108774bad92f36064f5fd59ed.md), Aesthetic Discrimination of Graph Layouts (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Aesthetic%20Discrimination%20of%20Graph%20Layouts%2025f75d8fd4b44bd99006e2316d28f6cd.md), A New Approach to Exact Crossing
Minimization (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/A%20New%20Approach%20to%20Exact%20Crossing%20Minimization%202545ef78b5004999bf3804868ae42b57.md), Improved circular layouts (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Improved%20circular%20layouts%2028b32d84950043d6863d591c7958a289.md), Deep Neural Network for DrawiNg
Networks (DNN)^2 (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Deep%20Neural%20Network%20for%20DrawiNg%20Networks%20(DNN)%5E2%2003d3da58c4f745d2a68f17a4f8a03d74.md), An Experimental Study of Crossing
Minimization Heuristics (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/An%20Experimental%20Study%20of%20Crossing%20Minimization%20Heu%202dcd254fe4054544b4b04ed8aefdf862.md), An experimental comparison of four graph drawing algorithms (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/An%20experimental%20comparison%20of%20four%20graph%20drawing%20a%204e117b9ce73d431ab1d9a29414ffff3a.md), A Note on the Practicality of Maximal Planar Subgraph Algorithms (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/A%20Note%20on%20the%20Practicality%20of%20Maximal%20Planar%20Subgr%203b027747aec54f60a35f138958faff21.md), Experimental Analysis of the Accessibility of Drawings with Few Segments (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Experimental%20Analysis%20of%20the%20Accessibility%20of%20Draw%20fa75403823b64e53aa237f1a840f7749.md), An Interactive Tool to Explore and Improve the Ply Number of Drawings (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/An%20Interactive%20Tool%20to%20Explore%20and%20Improve%20the%20Ply%20b8be8d1a88824561bc30d154b8a4603e.md), A Greedy Heuristic for Crossing-Angle Maximization (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/A%20Greedy%20Heuristic%20for%20Crossing-Angle%20Maximization%202261d227fc2c49b294182a9d923ed4ce.md), A Heuristic Approach Towards Drawings of Graphs with High Crossing Resolution (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/A%20Heuristic%20Approach%20Towards%20Drawings%20of%20Graphs%20wi%209f9855a1d44149ecba17ecc622b576f2.md), An Integer-Linear Program
for Bend-Minimization in Ortho-Radial
Drawings (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/An%20Integer-Linear%20Program%20for%20Bend-Minimization%20in%2003dc379afbc7449594201f5dbf23e048.md), Star-Struck by Fixed Embeddings:
Modern Crossing Number Heuristics (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Star-Struck%20by%20Fixed%20Embeddings%20Modern%20Crossing%20Nu%20f31c2a6c7b8d4683a1820d8101f89448.md), An effective crossing minimisation heuristic based on star insertion (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/An%20effective%20crossing%20minimisation%20heuristic%20based%205fde465c129249599b79396bf3d3ae04.md), Advances in the Planarization Method: Effective Multiple Edge Insertions (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Advances%20in%20the%20Planarization%20Method%20Effective%20Mul%20884c2bc419eb4197be261c1f1b3898ce.md), An ILP-based Proof System for the Crossing
Number Problem (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/An%20ILP-based%20Proof%20System%20for%20the%20Crossing%20Number%20%20e172212e85b74e12bcf2d0320d2b1eb6.md)

# Body

### Statistics

![four_in_one.svg](Rome-Lib%20c2f20984de724f4c89764b0bc494e99e/four_in_one.svg)

### Descriptions from Literature

From “[A branch-and-cut approach to the crossing number problem](https://doi.org/10.1016/j.disopt.2007.05.006)”:

> To test the performance of our new algorithm, we used a benchmark set of graphs of the University of Rome III, introduced in [11]. The set contains 11 389 graphs that consist of 10 to 100 nodes and 9 to 158 edges. These graphs were generated from a core set of 112 “real life” graphs used in database design and software engineering applications. Most of the graphs are sparse, which is a common property in most application areas of automatic graph drawing. The average ratio between the number of edges and the number of nodes of the graphs from the benchmark set is about 1.35.
> 

From “[Layer-free upward crossing minimization](https://doi.org/10.1145/1671970.1671975)”:

> The Rome graphs [Di Battista et al. 1997] are a widely used benchmark set in graph drawing, obtained from a basic set of 112 real-world graphs. It contains 11,528 instances with 10 through 100 nodes and 9 through 158 edges. Although the graphs are originally undirected, they have been used as directed graphs—by artificially directing the edges according to the node order given in the input files—for showing the performance of the mixed-upward planarization approach [Eiglsperger et al. 2003]. In this case, all edges are directed and the graphs are acyclic; hence, the mixed-upward planarization approach turns into an upward planarization method.
> 

From “[A New Approach to Exact Crossing Minimization](https://doi.org/10.1007/978-3-540-87744-8_24)”:

> We say graphs are trivial, if they are planar or if the heuristic achieves a planarization with only one crossing, as in these cases we need not prove optimality. The Rome library contains 7172 non-trivial graphs.
> 

From “[An Experimental Comparison of Four Graph Drawing Algorithms](https://doi.org/10.1016/s0925-7721(96)00005-3)”

> Our test graph generation strategy is as follows. First, we have focused on the important application area of database and software visualization, where Entity-Relationship diagrams and Data-Flow diagrams are usually displayed with orthogonal drawings. Second, we have collected 112 "real life" graphs with number of vertices between 10 and 100, from now on called core graphs, from the following sources:
> 

> • 54% of the graphs have been obtained from major Italian software companies (especially from Database Informatica) and large government organization (including the Italian Internal Revenue Service and the Italian National Advisory Council for Computer Applications in the Government (Autorita’ per l'Informatica nella Pubblica Amministrazione));
• 33% of the graphs were taken from well-known reference books in software engineering [18] and database design [1], and from journal articles on software visualization in the recent issues of Information Systems and the IEEE Transactions on Software Engineering;
• 13% of the graphs were extracted from theses in software and database visualization written by students at the University of Rome "La Sapienza".
> 

> Our approach is based on the following scheme. We defined several primitive operations for updating graphs, which correspond to the typical operations performed by designers of Entity-Relationship and Data-Flow Diagrams, and attributed a certain probability to each of them. More specifically, the updating primitives we have used are the following: InsertEdge, which inserts a new edge between two existing vertices; DeleteEdge, which deletes an existing edge; InsertVertex, which splits an existing edge into two edges by inserting a new vertex; DeleteVertex, which deletes a vertex and all its incident edges; and MakeVertex, which creates a new vertex and connects it to a subset of vertices. The test graphs were then generated in several iterations starting from the core graphs by applying random sequences of operations with a "genetic" mechanism. Namely, at each iteration a new set of test graphs was obtained by applying a random sequence of operations to the current test set. Each new graph was then evaluated for "suitability", and those found not suitable were discarded. The probability of each primitive operation was varied at the end of each iteration. The evaluation of the suitability of the generated graphs was conducted using both objective and subjective analyses. The objective analysis consisted of determining whether the new graph had similar structural properties with respect to the core graph it was derived from. We have taken into account parameters like the average ratio between number of vertices and number of edges and the average number of biconnected components. The subjective analysis consisted in a visual inspection of the new graph and an assessment by expert users of Entity-Relationship and Data-Flow diagrams of its similarity to a "real-life" diagram. For obvious reasons, the subjective analysis has been done on a randomly selected subset of the graphs.
> 

### Example Figures

From ”[An Experimental Comparison of Four Graph Drawing Algorithms](https://doi.org/10.1016/s0925-7721(96)00005-3)”:

![Untitled](Rome-Lib%20c2f20984de724f4c89764b0bc494e99e/Untitled.png)

From “[Experimental Analysis of the Accessibility of Drawings with Few Segments](https://doi.org/10.1007/978-3-319-73915-1_5)”:

![Untitled](Rome-Lib%20c2f20984de724f4c89764b0bc494e99e/Untitled%201.png)

From: [Deep Neural Network for DrawiNg Networks, (DNN)2](https://link.springer.com/chapter/10.1007/978-3-030-92931-2_27):

![Untitled](Rome-Lib%20c2f20984de724f4c89764b0bc494e99e/Untitled%202.png)

**Fig 5.**  Layout examples for (DNN)^2, (DNN)^2, tsNET∗ and S_GD^2.

=== STOP RENDERING ===

# Fig. 5.

Layout examples for (DNN)^2, (DNN)^2, tsNET∗ and S_GD^2.

From “[Deep Neural Network for DrawiNg Networks, (DNN)2](https://link.springer.com/chapter/10.1007/978-3-030-92931-2_27) “

![Untitled](Rome-Lib%20c2f20984de724f4c89764b0bc494e99e/Untitled%203.png)

Strastisfimal Layout Supplemental materials